import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:viserpay/core/helper/date_converter.dart';
import 'package:viserpay/core/helper/string_format_helper.dart';
import 'package:viserpay/core/utils/dimensions.dart';
import 'package:viserpay/core/utils/my_color.dart';
import 'package:viserpay/core/utils/my_strings.dart';
import 'package:viserpay/core/utils/style.dart';
import 'package:viserpay/data/model/reward/reward_response_model.dart';

class RewardEarnedCard extends StatelessWidget {
  final EarnedPointModel reward;
  final String currencySym;

  const RewardEarnedCard({super.key, required this.reward, required this.currencySym});

  @override
  Widget build(BuildContext context) {
    return Container(
      padding: EdgeInsets.symmetric(horizontal: Dimensions.space10, vertical: 10),
      decoration: BoxDecoration(),
      child: Row(
        children: [
          Expanded(
            flex: 2,
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                Text((reward.remark ?? "").tr.replaceAll("_", " ").toCapitalized(), style: semiBoldDefault.copyWith()),
                Text("$currencySym${StringConverter.formatNumber(reward.pointAbleAmount ?? "0.0")}", style: lightDefault.copyWith()),
                Text(DateConverter.convertIsoToString(reward.createdAt ?? ""), style: lightDefault.copyWith()),
              ],
            ),
          ),
          const SizedBox(width: Dimensions.space10),
          Text("+ ${reward.points} ${MyStrings.points.tr}", style: semiBoldDefault.copyWith(color: MyColor.greenSuccessColor)),
        ],
      ),
    );
  }
}
